/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWDescriptionPanel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionItem;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWFunctionConstants;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWFunctionGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWFunctionDescriptionPanel
extends JPanel
implements ListSelectionListener,
ActionListener,
IVWDescriptionPanel {
    public static final int DATA_TYPE_CONVERSION_FUNCTIONS = 1;
    public static final int GENERAL_FUNCTIONS = 2;
    public static final int NUMERIC_FUNCTIONS = 3;
    public static final int NULL_FUNCTIONS = 4;
    public static final int STEP_RESPONSE_FUNCTIONS = 5;
    public static final int STRING_FUNCTIONS = 6;
    public static final int SYSTEM_INTERROGATION_FUNCTIONS = 7;
    public static final int TIME_FUNCTIONS = 8;
    public static final int XML_FUNCTIONS = 9;
    public static final int MESSAGE_EXPANSION_FUNCTIONS = 10;
    public static final int ARRAY_FUNCTIONS = 12;
    public static final int XPATH_XSLT_FUNCTIONS = 13;
    public static final int ATTACHMENT_TEMPLATE_FUNCTIONS = 14;
    private VWToolbarBorder m_functionBorder = null;
    private JList m_functionList = null;
    private DefaultListModel m_functionListModel = null;
    private VWToolbarBorder m_syntaxBorder = null;
    private JTextField m_syntaxText = null;
    private JButton m_detailsButton = null;
    private GridBagConstraints m_gbCons = null;
    private VWFunctionGroup m_functionGroup = null;

    public void init() {
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
    }

    public void valueChanged(ListSelectionEvent event) {
        Object src = event.getSource();
        if (src == this.m_functionList) {
            this.performFunctionListValueChanged();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_detailsButton) {
            this.performDetailsAction();
        }
    }

    public void setExpressionItem(VWExpressionItem item) {
        Object expressionItem;
        this.m_functionGroup = null;
        if (item != null && (expressionItem = item.getExpressionItem()) instanceof VWFunctionGroup) {
            this.m_functionGroup = (VWFunctionGroup)expressionItem;
        }
        this.reinitialize();
    }

    public String getExpressionItem() {
        int nSelectedFunctionIndex;
        String expressionItem = null;
        String[][] functionList = this.m_functionGroup.getFunctionList();
        if (functionList != null && (nSelectedFunctionIndex = this.m_functionList.getSelectedIndex()) > -1) {
            expressionItem = this.createSyntaxString(functionList[nSelectedFunctionIndex]);
        }
        return expressionItem;
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.7;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 0);
        this.m_functionBorder = new VWToolbarBorder(VWResource.s_functions);
        this.add((Component)this.m_functionBorder, this.m_gbCons);
        JPanel functionPanel = this.m_functionBorder.getClientPanel();
        functionPanel.setLayout(new GridLayout());
        this.m_functionListModel = new DefaultListModel();
        this.m_functionList = new JList(this.m_functionListModel);
        this.m_functionList.addListSelectionListener(this);
        functionPanel.add(new JScrollPane(this.m_functionList));
        ++this.m_gbCons.gridy;
        this.m_gbCons.weighty = 0.0;
        this.m_syntaxBorder = new VWToolbarBorder(VWResource.s_syntax);
        this.add((Component)this.m_syntaxBorder, this.m_gbCons);
        JPanel syntaxPanel = this.m_syntaxBorder.getClientPanel();
        syntaxPanel.setLayout(new GridLayout());
        this.m_syntaxText = new JTextField();
        this.m_syntaxText.setEditable(false);
        this.m_syntaxText.setCaretPosition(0);
        syntaxPanel.add(this.m_syntaxText);
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        ++this.m_gbCons.gridy;
        this.m_gbCons.weighty = 0.3;
        this.m_detailsButton = new JButton(VWResource.s_details);
        this.m_detailsButton.addActionListener(this);
        this.add((Component)this.m_detailsButton, this.m_gbCons);
    }

    private void reinitialize() {
        int functionCount;
        String[][] functionList;
        this.m_functionList.removeListSelectionListener(this);
        this.m_functionListModel.removeAllElements();
        this.m_functionList.addListSelectionListener(this);
        if (this.m_functionGroup != null && (functionList = this.m_functionGroup.getFunctionList()) != null && (functionCount = functionList.length) > 0) {
            for (int i = 0; i < functionCount; ++i) {
                int count;
                String[] function = functionList[i];
                if (function == null || (count = function.length) <= 0) continue;
                this.m_functionListModel.addElement(function[0]);
            }
            this.m_functionList.setSelectedIndex(0);
        }
    }

    private void performFunctionListValueChanged() {
        this.m_syntaxText.setText("");
        int nIndex = this.m_functionList.getSelectedIndex();
        if (nIndex > -1) {
            String[][] functionList = this.m_functionGroup.getFunctionList();
            String[] selectedFunction = functionList[nIndex];
            String syntaxString = this.createSyntaxString(selectedFunction);
            this.m_syntaxText.setText(syntaxString);
            this.m_syntaxText.setCaretPosition(0);
        }
    }

    private void performDetailsAction() {
        String helpString = VWHelp.Help_General;
        switch (this.m_functionGroup.getType()) {
            case 1: {
                helpString = helpString + "bpfe005.htm";
                break;
            }
            case 2: {
                helpString = helpString + "bpfe006.htm";
                break;
            }
            case 3: {
                helpString = helpString + "bpfe010.htm";
                break;
            }
            case 4: {
                helpString = helpString + "bpfe009.htm";
                break;
            }
            case 5: {
                helpString = helpString + "bpfe002.htm";
                break;
            }
            case 6: {
                helpString = helpString + "bpfe012.htm";
                break;
            }
            case 7: {
                helpString = helpString + "bpfe007.htm";
                break;
            }
            case 8: {
                helpString = helpString + "bpfe013.htm";
                break;
            }
            case 9: {
                helpString = helpString + "bpfe014.htm";
                break;
            }
            case 10: {
                helpString = helpString + "bpfe008.htm";
                break;
            }
            case 12: {
                helpString = helpString + "bpfe003.htm";
                break;
            }
            case 13: {
                helpString = helpString + "bpfe015.htm";
                break;
            }
            case 14: {
                helpString = helpString + "bpfe004.htm";
            }
        }
        Object selectedValue = this.m_functionList.getSelectedValue();
        if (selectedValue != null) {
            String functionName = selectedValue.toString();
            helpString = helpString + "#" + functionName;
        }
        VWHelp.displayPage(helpString);
    }

    private String createSyntaxString(String[] functionInfo) {
        String syntaxString = null;
        if (functionInfo != null && functionInfo.length > 0) {
            int i;
            boolean bIsMacro = false;
            for (i = 0; i < VWFunctionConstants.MACROS.length; ++i) {
                if (VWStringUtils.compare(functionInfo[0], VWFunctionConstants.MACROS[i]) != 0) continue;
                bIsMacro = true;
                break;
            }
            if (!bIsMacro) {
                syntaxString = functionInfo[0] + "(";
                if (functionInfo.length > 1) {
                    for (i = 1; i < functionInfo.length; ++i) {
                        syntaxString = syntaxString + functionInfo[i];
                        if (i == functionInfo.length - 1) continue;
                        syntaxString = syntaxString + ", ";
                    }
                }
                syntaxString = syntaxString + ")";
            } else {
                syntaxString = functionInfo[1];
            }
        }
        return syntaxString;
    }
}

